
#ifndef __MB_SHARED_MEMORY_H
#define __MB_SHARED_MEMORY_H


/** MBShm all needed headers */
#include "OSAL.h"

/** Handle to the Shared memory resource. */
typedef struct MB_SHM_S* MB_SHM_H;

/** Function prototypes */
OSAL_RESULT
MbShm_Create(char*    pszName,
             uint32_t ulInstance,
             uint32_t ulByteSize);

OSAL_RESULT
MbShm_Delete(char* pszName,
             uint32_t ulInstance);

OSAL_RESULT
MbShm_Open(MB_SHM_H *phShm,
           char*    pszName,
           uint32_t ulInstance);

OSAL_RESULT
MbShm_Close(MB_SHM_H hShm);

OSAL_RESULT
MbShm_Set(MB_SHM_H hShm,
          uint32_t ulValue,
          uint32_t ulOffset,
          uint32_t ulBytes);

/** Shm read functions. */
OSAL_RESULT
MbShm_ReadBytes(MB_SHM_H hShm,
                void*    pvBuffer,
                uint32_t ulOffset,
                uint32_t ulBytes);

OSAL_RESULT
MbShm_ReadSwapBytes(MB_SHM_H hShm,
                    void*    pvBuffer,
                    uint32_t ulOffset,
                    uint32_t ulBytes);

OSAL_RESULT
MbShm_ReadBits(MB_SHM_H hShm,
               void*    pvBuffer,
               uint32_t ulBitOffset,
               uint32_t ulBitCount);

OSAL_RESULT
MbShm_ReadBitsSwapMode(MB_SHM_H hShm,
                       void*    pvBuffer,
                       uint32_t ulBitOffset,
                       uint32_t ulBitCount);


/** Shm write functions. */
OSAL_RESULT
MbShm_WriteBytes(MB_SHM_H hShm,
                 void*    pvBuffer,
                 uint32_t ulOffset,
                 uint32_t ulBytes);

OSAL_RESULT
MbShm_WriteSwapBytes(MB_SHM_H hShm,
                     void*    pvBuffer,
                     uint32_t ulOffset,
                     uint32_t ulBytes);


OSAL_RESULT
MbShm_WriteBits(MB_SHM_H hShm,
                void*    pvBuffer,
                uint32_t ulBitOffset,
                uint32_t ulBitCount);


OSAL_RESULT
MbShm_WriteBitsSwapMode(MB_SHM_H hShm,
                        void*    pvBuffer,
                        uint32_t ulBitOffset,
                        uint32_t ulBitCount);

bool
MbShm_CopyIfDifferent(MB_SHM_H hShm,
                      void* pvBufferToCmp,
                      void* pvDestBuffer,
                      uint32_t ulOffset,
                      uint32_t ulBytes);

OSAL_RESULT
MbShm_GetByteSize(MB_SHM_H hShm,
                  uint32_t* pulByteSize);

#endif
